function [neighbors,neighbors_lum,x] = find_neighbors2(vertex,nlist,nhood,n_bright)
%This little function is used to find all the points in a neighborhood
%around a central vertex
%Synatax:   [neighbors,neighbors_lum,x] = find_neighbors(vertex,nlist,nhood,n_bright);
%Input:     vertex = the point as defined by x,y,z around which the search
%                   is conducted
%           nlist = a x by 3 list of points that represent all the points
%                   around the vertex.
%           nhood = defines a cube 2xnhood around the vertex by whihc all
%                   the points in nlist will be filtered.
%           n_bright = the brightness associated with the vertex, actually
%                   any single point data associated with the vertex
%           x = is the index of the nearest vertices
%
%Output:    neighbors = A list of all the points surrounding the vertex
%                       within the neighborhood defined by nhood.
%           neighbors_lum = The matching luminance associated with the
%                       verticies in neighbors.
%           x = the index of the vertices

%parse data & error check
nlist_sz = size(nlist);
if nargin<3     %nhood = default
    nhood = 10;
end
if nargin<4
    n_bright = zeros(nlist_sz(1),1);
end
if nlist_sz(2)==2     %nlist must have a third column for z
    nlist_tmp = zeros(nlist_sz(1),1);     %z = 0 as a default
    nlist = cat(2,nlist,nlist_tmp);
    n_bright = zeros(nlist_sz(1),1);      %create the matching brightness data
elseif nlist_sz(2)~=3 %non standard input.
    error('the list of points you enter must be of the format [x;y;z]');
end
if size(vertex,2)==2     %same for vertex, must have a third column for z
    vertex = [vertex 0];     %z = 0 as a default
elseif size(vertex,2)~=3 %non standard input.
    error('the vertex you enter must be of the format [x;y;z]');
end


%Will you be my neighbor?
if ~isnan(vertex)       %the vertex cannot be NaN for this version
    %lets look for x first
    [x,y] = find(nlist(:,1)>vertex(1,1)+nhood | nlist(:,1)<vertex(1,1)-nhood);
    %lets look for y next
    [x2,y] = find(nlist(:,2)>vertex(1,2)+nhood | nlist(:,2)<vertex(1,2)-nhood);
    %lets look at z now
    [x3,y] = find(nlist(:,3)>vertex(1,3)+nhood | nlist(:,3)<vertex(1,3)-nhood);
    %concatenate the exclusion indexes and collapse the array
    x = vertcat(x,x2,x3);
    %x = unique(x);
    %create an index for the array
    idx = (1:nlist_sz(1))';
    %idx = linspace(1,nlist_sz(1),nlist_sz(1))';
    idx(x,:) = [];      %finalist index
    %output x
    x = idx;
    %nlist(x,:) = [];    %finalist
    %n_bright(x,:) = [];
    neighbors = nlist(x,:); %finalists
    neighbors_lum = n_bright(x,:);  %their brightness, other x factor.
else        %NaN out put NaN
    neighbors = NaN(1,3);
    neighbors_lum = NaN(1,size(n_bright,2));
    x = [];     %no nearest points
end
